// ProcessLock.cpp starts
// See ProcessLock.h

#include "ProcessLock.h"
#include "Debug.h"

ProcessLock::ProcessLock()
{
	lock = new BLocker();
}

ProcessLock::~ProcessLock()
{
	delete lock;
}

void ProcessLock::Lock()
{
	Debug('n', "ProcessLock::Lock: Entered");
	lock->Lock();
	Debug('n', "ProcessLock::Lock: Exited");
}

void ProcessLock::Unlock()
{
	Debug('n', "ProcessLock::Unlock: Entered");
	lock->Unlock();
	Debug('n', "ProcessLock::Unlock: Exited");
}

bool ProcessLock::IsLocked()
{
	return lock->IsLocked();
}

// ProcessLock.cpp ends